<?php
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: /login.php');
    exit;
}

$mobile_number = trim($_POST['mobile_number'] ?? '');
$password = $_POST['password'] ?? '';

// Validate inputs
if (empty($mobile_number) || empty($password)) {
    $_SESSION['error'] = 'Please fill in all fields';
    header('Location: /login.php');
    exit;
}

try {
    // Find user by mobile number
    $stmt = $pdo->prepare("SELECT * FROM users WHERE mobile_number = ?");
    $stmt->execute([$mobile_number]);
    $user = $stmt->fetch();

    if (!$user) {
        $_SESSION['error'] = 'Invalid mobile number or password';
        header('Location: /login.php');
        exit;
    }

    // Verify password
    if (!password_verify($password, $user['password'])) {
        $_SESSION['error'] = 'Invalid mobile number or password';
        header('Location: /login.php');
        exit;
    }

    // Login successful - set session
    $_SESSION['user_id'] = $user['id'];
    $_SESSION['mobile_number'] = $user['mobile_number'];
    $_SESSION['full_name'] = $user['full_name'];
    $_SESSION['email'] = $user['email'];
    $_SESSION['balance'] = $user['balance'];

    // Redirect to home dashboard
    header('Location: /index.php');
    exit;

} catch (PDOException $e) {
    $_SESSION['error'] = 'An error occurred. Please try again.';
    header('Location: /login.php');
    exit;
}
?>
