<?php
require_once 'config.php';
requireLogin();

// Fetch latest user data
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch();

if (!$user) {
    session_destroy();
    header('Location: /login.php');
    exit;
}

// Update session with latest data
$_SESSION['balance'] = $user['balance'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PB Cash - Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: #f5f5f5;
            min-height: 100vh;
        }

        .header {
            background: linear-gradient(135deg, #5b4cff 0%, #7c66ff 100%);
            color: white;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(91, 76, 255, 0.3);
        }

        .header-content {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 20px;
            font-weight: 600;
        }

        .logo-icon {
            width: 35px;
            height: 35px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #5b4cff;
        }

        .logout-btn {
            background: rgba(255, 255, 255, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.3);
            color: white;
            padding: 10px 20px;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .logout-btn:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
        }

        .welcome-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
        }

        .welcome-card h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 28px;
        }

        .welcome-card p {
            color: #666;
            font-size: 16px;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
            transition: transform 0.3s;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-card .icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-bottom: 15px;
        }

        .stat-card.balance .icon {
            background: linear-gradient(135deg, #5b4cff 0%, #7c66ff 100%);
            color: white;
        }

        .stat-card.ads .icon {
            background: linear-gradient(135deg, #ff6b6b 0%, #ff8787 100%);
            color: white;
        }

        .stat-card.tasks .icon {
            background: linear-gradient(135deg, #51cf66 0%, #69db7c 100%);
            color: white;
        }

        .stat-card.referrals .icon {
            background: linear-gradient(135deg, #ffd43b 0%, #ffe066 100%);
            color: white;
        }

        .stat-card h3 {
            color: #666;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 8px;
            text-transform: uppercase;
        }

        .stat-card .value {
            color: #333;
            font-size: 32px;
            font-weight: 700;
        }

        .info-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
        }

        .info-card h2 {
            color: #333;
            margin-bottom: 20px;
            font-size: 22px;
        }

        .info-item {
            display: flex;
            justify-content: space-between;
            padding: 15px 0;
            border-bottom: 1px solid #f0f0f0;
        }

        .info-item:last-child {
            border-bottom: none;
        }

        .info-label {
            color: #666;
            font-weight: 500;
        }

        .info-value {
            color: #333;
            font-weight: 600;
        }

        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                gap: 15px;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .welcome-card h1 {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <div class="logo">
                <div class="logo-icon">
                    <i class="fas fa-wallet"></i>
                </div>
                <span>PB Cash</span>
            </div>
            <a href="auth/logout.php" class="logout-btn">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </div>
    </div>

    <div class="container">
        <div class="welcome-card">
            <h1>Welcome back, <?php echo htmlspecialchars($user['full_name']); ?>! 👋</h1>
            <p>Manage your account and track your earnings</p>
        </div>

        <div class="stats-grid">
            <div class="stat-card balance">
                <div class="icon">
                    <i class="fas fa-wallet"></i>
                </div>
                <h3>Current Balance</h3>
                <div class="value">৳<?php echo number_format($user['balance'], 2); ?></div>
            </div>

            <div class="stat-card ads">
                <div class="icon">
                    <i class="fas fa-tv"></i>
                </div>
                <h3>Ads Watched</h3>
                <div class="value"><?php echo $user['ads_watched'] ?? 0; ?></div>
            </div>

            <div class="stat-card tasks">
                <div class="icon">
                    <i class="fas fa-tasks"></i>
                </div>
                <h3>Tasks Completed</h3>
                <div class="value">
                    <?php
                    $stmt = $pdo->prepare("SELECT COUNT(*) FROM user_tasks WHERE user_id = ?");
                    $stmt->execute([$user['id']]);
                    echo $stmt->fetchColumn();
                    ?>
                </div>
            </div>

            <div class="stat-card referrals">
                <div class="icon">
                    <i class="fas fa-users"></i>
                </div>
                <h3>Referrals</h3>
                <div class="value">
                    <?php
                    $stmt = $pdo->prepare("SELECT COUNT(*) FROM referrals WHERE referrer_id = ?");
                    $stmt->execute([$user['id']]);
                    echo $stmt->fetchColumn();
                    ?>
                </div>
            </div>
        </div>

        <div class="info-card">
            <h2>Account Information</h2>
            <div class="info-item">
                <span class="info-label">Full Name</span>
                <span class="info-value"><?php echo htmlspecialchars($user['full_name']); ?></span>
            </div>
            <div class="info-item">
                <span class="info-label">Mobile Number</span>
                <span class="info-value"><?php echo htmlspecialchars($user['mobile_number']); ?></span>
            </div>
            <div class="info-item">
                <span class="info-label">Email</span>
                <span class="info-value"><?php echo htmlspecialchars($user['email']); ?></span>
            </div>
            <div class="info-item">
                <span class="info-label">Account Status</span>
                <span class="info-value" style="color: #51cf66;">
                    <i class="fas fa-check-circle"></i> Active
                </span>
            </div>
            <div class="info-item">
                <span class="info-label">Member Since</span>
                <span class="info-value">
                    <?php echo date('F j, Y', strtotime($user['created_at'])); ?>
                </span>
            </div>
        </div>
    </div>
</body>
</html>
