<?php
require_once 'config.php';
requireLogin();

// Fetch latest user data
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch();

if (!$user) {
    session_destroy();
    header('Location: /login.php');
    exit;
}

$_SESSION['balance'] = $user['balance'];

// Get user's first name for display
$displayName = $user['full_name'];
if (strpos($displayName, ' ') !== false) {
    $displayName = explode(' ', $displayName)[0];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PB Cash - Home</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: #f5f5f5;
            min-height: 100vh;
            padding-bottom: 80px;
        }

        .header {
            background: linear-gradient(135deg, #5b4cff 0%, #7c66ff 100%);
            color: white;
            padding: 20px;
            border-radius: 0 0 25px 25px;
            box-shadow: 0 4px 15px rgba(91, 76, 255, 0.2);
        }

        .user-info {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 15px;
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .avatar {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            color: #5b4cff;
            font-weight: 600;
            border: 3px solid rgba(255, 255, 255, 0.3);
        }

        .user-name {
            font-size: 18px;
            font-weight: 600;
        }

        .notification-btn {
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 18px;
            cursor: pointer;
            transition: all 0.3s;
        }

        .notification-btn:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        .balance-btn {
            background: white;
            color: #5b4cff;
            padding: 12px 20px;
            border-radius: 25px;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            font-weight: 600;
            font-size: 15px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            cursor: pointer;
            transition: all 0.3s;
        }

        .balance-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.15);
        }

        .balance-icon {
            background: #5b4cff;
            width: 24px;
            height: 24px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 12px;
        }

        .container {
            padding: 20px;
        }

        .banner {
            background: linear-gradient(135deg, #8b1b8a 0%, #5b1b5a 100%);
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 25px;
            color: white;
            position: relative;
            overflow: hidden;
            box-shadow: 0 4px 15px rgba(139, 27, 138, 0.3);
        }

        .banner-content {
            position: relative;
            z-index: 2;
        }

        .banner-text {
            font-size: 16px;
            line-height: 1.8;
            margin-bottom: 8px;
        }

        .banner-image {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            width: 120px;
            opacity: 0.9;
        }

        .menu-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 15px;
            margin-bottom: 25px;
        }

        .menu-item {
            background: white;
            border-radius: 15px;
            padding: 20px 10px;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
            transition: all 0.3s;
            cursor: pointer;
            text-decoration: none;
            color: #333;
        }

        .menu-item:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.12);
        }

        .menu-icon {
            font-size: 32px;
            margin-bottom: 8px;
            color: #333;
        }

        .menu-label {
            font-size: 13px;
            font-weight: 500;
        }

        .promo-section {
            background: white;
            border-radius: 15px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .youtube-icon {
            width: 60px;
            height: 60px;
            background: #ff0000;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 30px;
            flex-shrink: 0;
        }

        .promo-text {
            flex: 1;
        }

        .promo-title {
            font-size: 15px;
            font-weight: 600;
            color: #333;
            margin-bottom: 4px;
        }

        .promo-subtitle {
            font-size: 14px;
            color: #666;
        }

        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            padding: 12px 0 8px;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.08);
            z-index: 100;
        }

        .nav-item {
            text-align: center;
            color: #666;
            text-decoration: none;
            transition: all 0.3s;
        }

        .nav-item.active {
            color: #5b4cff;
        }

        .nav-item .nav-icon {
            font-size: 24px;
            margin-bottom: 4px;
        }

        .nav-item .nav-label {
            font-size: 12px;
            font-weight: 500;
        }

        @media (max-width: 480px) {
            .menu-grid {
                grid-template-columns: repeat(4, 1fr);
                gap: 10px;
            }

            .menu-item {
                padding: 15px 8px;
            }

            .menu-icon {
                font-size: 28px;
            }

            .menu-label {
                font-size: 12px;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="user-info">
            <div class="user-profile">
                <div class="avatar">
                    <?php echo strtoupper(substr($displayName, 0, 1)); ?>
                </div>
                <div class="user-name"><?php echo htmlspecialchars($displayName); ?></div>
            </div>
            <div class="notification-btn">
                <i class="fas fa-bell"></i>
            </div>
        </div>
        <div class="balance-btn">
            <div class="balance-icon">
                <i class="fas fa-wallet"></i>
            </div>
            <span>Balance: ৳<?php echo number_format($user['balance'], 2); ?></span>
        </div>
    </div>

    <div class="container">
        <div class="banner">
            <div class="banner-content">
                <div class="banner-text">১০০০ টাকা ডিপোজিট করলে</div>
                <div class="banner-text">১০০ টাকা বোনাস</div>
                <div class="banner-text">২০০০ টাকা ডিপোজিট করলে</div>
                <div class="banner-text">৬০০ টাকা বোনাস</div>
            </div>
        </div>

        <div class="menu-grid">
            <a href="#" class="menu-item">
                <div class="menu-icon"><i class="fas fa-check-circle"></i></div>
                <div class="menu-label">Task</div>
            </a>
            <a href="#" class="menu-item">
                <div class="menu-icon"><i class="fas fa-money-bill-wave"></i></div>
                <div class="menu-label">Deposit</div>
            </a>
            <a href="#" class="menu-item">
                <div class="menu-icon"><i class="fas fa-hand-holding-usd"></i></div>
                <div class="menu-label">Withdraw</div>
            </a>
            <a href="#" class="menu-item">
                <div class="menu-icon"><i class="fas fa-box"></i></div>
                <div class="menu-label">Plan</div>
            </a>
            <a href="dashboard.php" class="menu-item">
                <div class="menu-icon"><i class="fas fa-user"></i></div>
                <div class="menu-label">Profile</div>
            </a>
            <a href="#" class="menu-item">
                <div class="menu-icon"><i class="fas fa-user-friends"></i></div>
                <div class="menu-label">Refer</div>
            </a>
            <a href="#" class="menu-item">
                <div class="menu-icon"><i class="fas fa-history"></i></div>
                <div class="menu-label">Transaction</div>
            </a>
            <a href="#" class="menu-item">
                <div class="menu-icon"><i class="fas fa-headset"></i></div>
                <div class="menu-label">HelpLine</div>
            </a>
        </div>

        <div class="promo-section">
            <div class="youtube-icon">
                <i class="fab fa-youtube"></i>
            </div>
            <div class="promo-text">
                <div class="promo-title">কিভাবে কাজ করবেন?</div>
                <div class="promo-subtitle">ভিডিও দেখুন</div>
            </div>
        </div>
    </div>

    <div class="bottom-nav">
        <a href="index.php" class="nav-item active">
            <div class="nav-icon"><i class="fas fa-home"></i></div>
            <div class="nav-label">Home</div>
        </a>
        <a href="#" class="nav-item">
            <div class="nav-icon"><i class="fas fa-users"></i></div>
            <div class="nav-label">Team</div>
        </a>
        <a href="#" class="nav-item">
            <div class="nav-icon"><i class="fas fa-clock"></i></div>
            <div class="nav-label">History</div>
        </a>
        <a href="dashboard.php" class="nav-item">
            <div class="nav-icon"><i class="fas fa-th-large"></i></div>
            <div class="nav-label">Dashboard</div>
        </a>
    </div>
</body>
</html>
