<?php
require_once 'config.php';
redirectIfLoggedIn();

$error = isset($_SESSION['error']) ? $_SESSION['error'] : '';
$success = isset($_SESSION['success']) ? $_SESSION['success'] : '';
unset($_SESSION['error'], $_SESSION['success']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PB Cash - Login</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: #f5f5f5;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .login-container {
            width: 100%;
            max-width: 420px;
        }

        .logo-wrapper {
            text-align: center;
            margin-bottom: 40px;
        }

        .logo-circle {
            width: 120px;
            height: 120px;
            margin: 0 auto;
            background: white;
            border-radius: 50%;
            border: 4px solid #d4c5ff;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 15px rgba(91, 76, 255, 0.1);
        }

        .logo-content {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .logo-icon {
            width: 35px;
            height: 35px;
            background: linear-gradient(135deg, #5b4cff 0%, #7c66ff 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 18px;
            font-weight: bold;
        }

        .logo-text {
            font-size: 18px;
            font-weight: 600;
            color: #333;
        }

        .login-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        }

        .form-group {
            margin-bottom: 20px;
        }

        .input-wrapper {
            position: relative;
            display: flex;
            align-items: center;
            border: 1px solid #e0e0e0;
            border-radius: 12px;
            padding: 15px 20px;
            background: #fafafa;
            transition: all 0.3s;
        }

        .input-wrapper:focus-within {
            border-color: #5b4cff;
            background: white;
        }

        .input-icon {
            font-size: 20px;
            color: #333;
            margin-right: 15px;
            min-width: 20px;
            text-align: center;
        }

        .form-input {
            border: none;
            outline: none;
            flex: 1;
            font-size: 15px;
            color: #333;
            background: transparent;
        }

        .form-input::placeholder {
            color: #999;
        }

        .login-btn {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #5b4cff 0%, #7c66ff 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            cursor: pointer;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(91, 76, 255, 0.3);
        }

        .login-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(91, 76, 255, 0.4);
        }

        .login-btn:active {
            transform: translateY(0);
        }

        .register-link {
            text-align: center;
            margin-top: 25px;
        }

        .register-link p {
            color: #666;
            font-size: 14px;
            margin-bottom: 5px;
        }

        .register-link a {
            color: #5b4cff;
            text-decoration: none;
            font-weight: 600;
            font-size: 15px;
        }

        .register-link a:hover {
            text-decoration: underline;
        }

        .alert {
            padding: 12px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-size: 14px;
        }

        .alert-error {
            background: #fee;
            color: #c33;
            border: 1px solid #fcc;
        }

        .alert-success {
            background: #efe;
            color: #3c3;
            border: 1px solid #cfc;
        }

        @media (max-width: 480px) {
            .login-card {
                padding: 30px 20px;
            }

            .logo-circle {
                width: 100px;
                height: 100px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo-wrapper">
            <div class="logo-circle">
                <div class="logo-content">
                    <div class="logo-icon">
                        <i class="fas fa-wallet"></i>
                    </div>
                    <div class="logo-text">PB Cash</div>
                </div>
            </div>
        </div>

        <div class="login-card">
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i> <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>

            <?php if ($success): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i> <?php echo htmlspecialchars($success); ?>
                </div>
            <?php endif; ?>

            <form action="auth/login_process.php" method="POST">
                <div class="form-group">
                    <div class="input-wrapper">
                        <i class="fas fa-phone input-icon"></i>
                        <input type="text" name="mobile_number" class="form-input" placeholder="Enter Mobile Number" required>
                    </div>
                </div>

                <div class="form-group">
                    <div class="input-wrapper">
                        <i class="fas fa-lock input-icon"></i>
                        <input type="password" name="password" class="form-input" placeholder="Enter Password" required>
                    </div>
                </div>

                <button type="submit" class="login-btn">Login</button>
            </form>

            <div class="register-link">
                <p>Not registered yet?</p>
                <a href="register.php">Create New Account</a>
            </div>
        </div>
    </div>
</body>
</html>
