<?php
require_once 'config.php';
redirectIfLoggedIn();

$error = isset($_SESSION['error']) ? $_SESSION['error'] : '';
unset($_SESSION['error']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PB Cash - Register</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: #f5f5f5;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .register-container {
            width: 100%;
            max-width: 420px;
        }

        .logo-wrapper {
            text-align: center;
            margin-bottom: 30px;
        }

        .logo-circle {
            width: 110px;
            height: 110px;
            margin: 0 auto;
            background: white;
            border-radius: 50%;
            border: 4px solid #d4c5ff;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 15px rgba(91, 76, 255, 0.1);
        }

        .logo-content {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .logo-icon {
            width: 32px;
            height: 32px;
            background: linear-gradient(135deg, #5b4cff 0%, #7c66ff 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 16px;
            font-weight: bold;
        }

        .logo-text {
            font-size: 16px;
            font-weight: 600;
            color: #333;
        }

        .register-card {
            background: white;
            border-radius: 20px;
            padding: 35px 30px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        }

        .form-group {
            margin-bottom: 18px;
        }

        .input-wrapper {
            position: relative;
            display: flex;
            align-items: center;
            border: 1px solid #e0e0e0;
            border-radius: 12px;
            padding: 14px 18px;
            background: #fafafa;
            transition: all 0.3s;
        }

        .input-wrapper:focus-within {
            border-color: #5b4cff;
            background: white;
        }

        .input-icon {
            font-size: 18px;
            color: #333;
            margin-right: 15px;
            min-width: 18px;
            text-align: center;
        }

        .form-input {
            border: none;
            outline: none;
            flex: 1;
            font-size: 14px;
            color: #333;
            background: transparent;
        }

        .form-input::placeholder {
            color: #999;
        }

        .register-btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #5b4cff 0%, #7c66ff 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
            box-shadow: 0 4px 15px rgba(91, 76, 255, 0.3);
        }

        .register-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(91, 76, 255, 0.4);
        }

        .register-btn:active {
            transform: translateY(0);
        }

        .login-link {
            text-align: center;
            margin-top: 22px;
        }

        .login-link p {
            color: #666;
            font-size: 14px;
            margin-bottom: 5px;
        }

        .login-link a {
            color: #5b4cff;
            text-decoration: none;
            font-weight: 600;
            font-size: 15px;
        }

        .login-link a:hover {
            text-decoration: underline;
        }

        .alert {
            padding: 12px 18px;
            border-radius: 10px;
            margin-bottom: 18px;
            font-size: 14px;
        }

        .alert-error {
            background: #fee;
            color: #c33;
            border: 1px solid #fcc;
        }

        @media (max-width: 480px) {
            .register-card {
                padding: 28px 20px;
            }

            .logo-circle {
                width: 95px;
                height: 95px;
            }

            .form-group {
                margin-bottom: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="register-container">
        <div class="logo-wrapper">
            <div class="logo-circle">
                <div class="logo-content">
                    <div class="logo-icon">
                        <i class="fas fa-wallet"></i>
                    </div>
                    <div class="logo-text">PB Cash</div>
                </div>
            </div>
        </div>

        <div class="register-card">
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i> <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>

            <form action="auth/register_process.php" method="POST">
                <div class="form-group">
                    <div class="input-wrapper">
                        <i class="fas fa-user input-icon"></i>
                        <input type="text" name="full_name" class="form-input" placeholder="Enter Full Name" required>
                    </div>
                </div>

                <div class="form-group">
                    <div class="input-wrapper">
                        <i class="fas fa-phone input-icon"></i>
                        <input type="text" name="mobile_number" class="form-input" placeholder="Enter Mobile Number" required>
                    </div>
                </div>

                <div class="form-group">
                    <div class="input-wrapper">
                        <i class="fas fa-envelope input-icon"></i>
                        <input type="email" name="email" class="form-input" placeholder="Enter Email" required>
                    </div>
                </div>

                <div class="form-group">
                    <div class="input-wrapper">
                        <i class="fas fa-lock input-icon"></i>
                        <input type="password" name="password" class="form-input" placeholder="Enter Password" required>
                    </div>
                </div>

                <div class="form-group">
                    <div class="input-wrapper">
                        <i class="fas fa-lock input-icon"></i>
                        <input type="password" name="confirm_password" class="form-input" placeholder="Enter Confirm Password" required>
                    </div>
                </div>

                <button type="submit" class="register-btn">Register</button>
            </form>

            <div class="login-link">
                <p>Have an account?</p>
                <a href="login.php">Login Now</a>
            </div>
        </div>
    </div>
</body>
</html>
