# PB Cash - User Management System

## Overview
A modern PHP-based user management and earning platform with PostgreSQL database. Users can register, login, and access a feature-rich dashboard for managing their account.

## Features Implemented

### Authentication System
- ✅ **User Registration** - Mobile number, email, and password-based signup
- ✅ **User Login** - Secure authentication with password hashing
- ✅ **Session Management** - Persistent user sessions
- ✅ **Logout** - Clean session termination

### Dashboard Features
- ✅ **Home Dashboard** - Modern UI with user profile, balance display, and quick access menu
- ✅ **Profile Dashboard** - Detailed account information and statistics
- ✅ **Balance Tracking** - Real-time balance display
- ✅ **Menu System** - 8 feature categories (Task, Deposit, Withdraw, Plan, Profile, Refer, Transaction, HelpLine)
- ✅ **Bottom Navigation** - Easy navigation between Home, Team, History, and Dashboard

## Technology Stack

### Backend
- **Language**: PHP 8.2
- **Database**: PostgreSQL (Replit managed)
- **Authentication**: Session-based with password hashing (bcrypt)
- **PDO**: For secure database queries with prepared statements

### Frontend
- **HTML5 & CSS3**: Modern responsive design
- **Font Awesome**: Icon library
- **Mobile-First**: Optimized for mobile devices

## File Structure

```
/
├── index.php              # Main dashboard (home page)
├── login.php              # Login page
├── register.php           # Registration page
├── dashboard.php          # Profile/account dashboard
├── config.php             # Database connection & session management
├── auth/                  # Authentication handlers
│   ├── login_process.php      # Login processing
│   ├── register_process.php   # Registration processing
│   └── logout.php             # Logout handler
└── attached_assets/       # Uploaded files
```

## Database Schema

### users table
```sql
- id (BIGINT) - Auto-generated unique ID
- full_name (VARCHAR) - User's full name
- mobile_number (VARCHAR) - Unique mobile number
- email (VARCHAR) - Unique email address
- password (VARCHAR) - Hashed password
- balance (DECIMAL) - User balance
- ads_watched (INTEGER) - Count of ads watched
- is_premium (BOOLEAN) - Premium status
- created_at (TIMESTAMP) - Registration date
- updated_at (TIMESTAMP) - Last update
```

### Other tables (ready for future features)
- **admin** - Admin credentials
- **tasks** - Task management
- **user_tasks** - Task completion tracking
- **withdrawals** - Withdrawal requests
- **ads_watched** - Ad viewing history
- **referrals** - Referral system

## User Flow

1. **First Visit**: User sees login page
2. **Registration**: Click "Create New Account" → Fill form → Submit
3. **Auto Login**: After registration, redirects to login with success message
4. **Login**: Enter mobile number & password → Submit
5. **Dashboard**: Redirects to main dashboard (index.php)
6. **Navigation**: Access features via menu or bottom nav
7. **Logout**: Click logout from profile dashboard

## Security Features

✅ **Password Hashing**: Using PHP's `password_hash()` with bcrypt
✅ **SQL Injection Protection**: All queries use PDO prepared statements
✅ **Session Security**: Session-based authentication
✅ **Input Validation**: Server-side validation for all inputs
✅ **XSS Protection**: Output escaping with `htmlspecialchars()`
✅ **Unique Constraints**: Email and mobile number uniqueness enforced

## Database Connection

All connection details via environment variables:
- `PGHOST` - Database host
- `PGPORT` - Database port
- `PGDATABASE` - Database name
- `PGUSER` - Database username
- `PGPASSWORD` - Database password

## Design Features

### Color Scheme
- **Primary**: Purple gradient (#5b4cff to #7c66ff)
- **Accent**: Deep purple for banners (#8b1b8a)
- **Background**: Light gray (#f5f5f5)
- **Cards**: White with subtle shadows

### Responsive Design
- Mobile-optimized layouts
- Touch-friendly buttons
- Adaptive grid systems
- Bottom navigation for mobile

### UI Components
- Gradient headers
- Card-based layouts
- Icon-based navigation
- Animated hover effects
- Shadow depth for elevation

## Future Features (Database Ready)

The database already supports these features for future development:
- Task completion system
- Ad watching rewards
- Withdrawal system
- Referral program
- Transaction history
- Team management
- Premium subscriptions

## Running the Application

The application runs on PHP's built-in server:
```bash
php -S 0.0.0.0:5000
```

Access at: Port 5000 webview

## Notes

- All authentication flows are complete and functional
- Database is PostgreSQL (converted from MySQL for Replit compatibility)
- Session management is secure and persistent
- Design matches provided screenshots exactly
- Ready for additional feature development
